/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.collect.Maps;
import cz.insophy.inplan.planning.mokos.AbstractPlanningScorer;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Util;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class MinTightDateScorer
extends AbstractPlanningScorer<Long> {
    private Map<Operation, Long> minTightDates = Maps.newIdentityHashMap();
    boolean useBranchMethod = false;

    public MinTightDateScorer() {
        super("tight_date_score");
    }

    @Override
    protected Long getPlanningScore(Operation op, Operation.OperationPlanning planning) {
        long minTightDate = this.getMinTightDate(op);
        long planningEnd = Util.getLastPlannedWa(planning).getEnd();
        return -1L * (minTightDate - planningEnd);
    }

    @Override
    public void onOperationPlanned(Operation op) {
        this.minTightDates.keySet().removeAll(op.getLaOps());
    }

    private long getMinTightDate(Operation op) {
        Long res = this.minTightDates.get(op);
        if (res == null) {
            res = this.useBranchMethod ? Long.valueOf(this.getMinTightDateBranch(op)) : this.getMinTightDateOld(op);
            this.minTightDates.put(op, res);
        }
        return res;
    }

    private Long getMinTightDateOld(Operation op) {
        GeneralizedActionRequest otherGar;
        GeneralizedActionRequest gar = op.getGar();
        GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
        List<GeneralizedActionRequest> gars = gor.getGars();
        long minTightDate = gor.getDueDate();
        ListIterator<GeneralizedActionRequest> backGarIt = gars.listIterator(gars.size());
        while (backGarIt.hasPrevious() && (otherGar = backGarIt.previous()) != gar) {
            minTightDate -= otherGar.getAction().timeToMake(otherGar.getAmount());
            minTightDate -= otherGar.getAction().getMinTimeToPrepare();
        }
        Long res = minTightDate;
        return res;
    }

    private long getMinTightDateBranch(Operation op) {
        long minBranchEnd = Long.MAX_VALUE;
        if (op.getSuccessors().isEmpty()) {
            GeneralizedActionRequest gar = op.getGar();
            return ProductionTreeAlgorithms.getNearestGor(gar).getDueDate();
        }
        for (Operation o : op.getSuccessors()) {
            minBranchEnd = Math.min(minBranchEnd, this.getMinBranchEnd(o, 0L));
        }
        return minBranchEnd;
    }

    private long getMinBranchEnd(Operation op, long timeAccumulator) {
        long minBranchEnd = Long.MAX_VALUE;
        GeneralizedActionRequest gar = op.getGar();
        Action action = op.getAction();
        long opLength = action.timeToMake(gar.getAmount()) + action.getMinTimeToPrepare();
        timeAccumulator += opLength;
        if (this.minTightDates.containsKey(op)) {
            return this.minTightDates.get(op) - timeAccumulator;
        }
        if (op.getSuccessors().isEmpty()) {
            return ProductionTreeAlgorithms.getNearestGor(gar).getDueDate() - timeAccumulator;
        }
        for (Operation operation : op.getSuccessors()) {
            long branchEnd = this.getMinBranchEnd(operation, timeAccumulator);
            if (branchEnd >= minBranchEnd) continue;
            minBranchEnd = branchEnd;
        }
        return minBranchEnd;
    }

    public void setUseBranchMethod(boolean useBranchMethod) {
        this.useBranchMethod = useBranchMethod;
    }

    public boolean isUseBranchMethod() {
        return this.useBranchMethod;
    }
}

